import { DogData } from '@/components/DogInfo/data';
import videojs from 'video.js'

const Component = videojs.getComponent('Component');

class DogTrack extends Component {
  trackData = [] //传入初始数组
  dogDiv = new Map()
  processing = false//是否在处理中
  firstShowTrack = false
  isReplaceDisplayNone = false
  arrayIndex = 0
  preCurrentTime = 0
  isExtract = false

  constructor(player, options) {
    super(player, options);

    player.on("loadedmetadata", () => {
      console.log("视频时长单位秒", player.duration())
    })
    player.on("timeupdate", () => this.update())
    // player.on("fullscreenchange", (e) => this.fullScreenChange.call(this_, e, player))
    player.on("ended", () => {
      this.arrayIndex = 0;
    })
    // player.on("ready", () => {
    //   console.log("ready")
    // })
  }


  update() {
    if (this.processing || this.trackData.length === 0) return
    this.processing = true
    const currentTime = this.player_.currentTime() * 1000
    //假如调整的播放时间则初始数组索引
    if (currentTime - this.preCurrentTime <= 0) {
      this.dispose()
    }
    //上次播放时间
    this.preCurrentTime = currentTime
    const firstFrameIndexTime = this.trackData[0][0] * 40
    //当前时间小于第一帧时间则直接跳过循环
    if (currentTime < firstFrameIndexTime) {
      this.processing = false
      return
    }
    for (let i = this.arrayIndex; i < this.trackData.length; i++) {
      const d = this.trackData[i]
      const diffTime = Math.abs(d[0] * 40 - currentTime)
      if (this.isExtract && diffTime < 300 || !this.isExtract && diffTime < 100 && currentTime <= d[0] * 40) {
        this.arrayIndex = i == 0 ? 1 : i
        this.trackDogs(d[1])
        break;
      }
      else {
        this.hideTrack()
      }
    }
    this.processing = false
  }

  trackDogs(dogs) {
    if (!dogs) return
    for (const [key, value] of dogs.entries()) {
      const myel = this.dogDiv.get(key)
      //跟踪框大小
      myel[0].style.width = `${(value.x2 - value.x1) * this.player_.currentWidth()}px`
      myel[0].style.height = `${(value.y2 - value.y1) * (this.player_.currentHeight() + 30)}px`
      //跟踪框位置
      const t = value.y1 * this.player_.currentHeight()
      const l = value.x1 * this.player_.currentWidth()
      myel[0].style.top = `${t}px`
      myel[0].style.left = `${l}px`
      myel[1].style.top = `${t - 21}px`
      myel[1].style.left = `${l - 5}px`

      myel[0].className = myel[0].className.replace(/display-none/ig, "")
      myel[1].className = myel[1].className.replace(/display-none/ig, "")
    }
    //清理掉当前frame没有的dog追踪
    for (const id of this.dogDiv.keys()) {
      if (!dogs.has(id)) {
        const arrEl = this.dogDiv.get(id)
        arrEl[0].classList.add("display-none")
        arrEl[1].classList.add("display-none")
      }
    }
  }

  hideTrack() {
    for (const id of this.dogDiv.keys()) {
      const arrEl = this.dogDiv.get(id)
      if (!arrEl[0].classList.contains('display-none')) {
        arrEl[0].classList.add("display-none")
      }
      if (!arrEl[1].classList.contains('display-none')) {
        arrEl[1].classList.add("display-none")
      }
    }
  }

  initData(dogIds: any, data: any, currentDog: DogData) {
    if (!data || data.length === 0) return;
    this.isExtract = currentDog.labelFileName.indexOf('extract') > -1
    //先清理之前狗跟踪的div
    this.clearOldDogDiv()
    this.dispose()
    //再清理数据
    this.dogDiv.clear()
    this.trackData.length = 0
    //创建狗的跟踪框
    this.createDogDiv(dogIds, currentDog.id + '')
    //frame map 转数组
    this.trackData = Array.from(data);
    //播放时间跳转到第一帧时间
    setTimeout(() => {
      this.player_.currentTime((currentDog.startFrameIndex * 40 - 30) / 1000)
      this.player_.play()
      /*
      const numberDogId = Number(currentDog.id)
      console.log('标识文件dogIds:', dogIds)
      // console.log('1442513510146908200', dogIds.get(1442513510146908200))
      console.log('current-dogId:' + currentDog.id, dogIds.get(currentDog.id * 1))
      if (dogIds && dogIds.has(numberDogId)) {
        console.log('currentDog', currentDog, currentDog.startFrameIndex * 40 - 30)
        this.player_.currentTime((currentDog.startFrameIndex * 40 - 30) / 1000)
        this.player_.play()
      }*/
    }, 100);
  }

  createDogDiv(dogIds: any, currentDogId: string) {
    if (!dogIds || dogIds.size === 0) return;
    //@ts-ignore
    const myContainer = this.player_.el_;
    // console.log("key currentDogId", dogIds, currentDogId, myContainer)
    for (const [key, value] of dogIds) {
      //定位框元素
      const el = document.createElement("div")
      el.id = `dog_${key}`
      el.classList.add("display-none")
      //dog name
      const dogNameEl = document.createElement("div")
      dogNameEl.classList.add("najiu-dog-track-dog-name")
      dogNameEl.classList.add("display-none")
      dogNameEl.id = `dog_name_${key}`
      //@ts-ignore
      const dogName = document.createTextNode(`狗-${value.obj_id}`)
      if (key == currentDogId) {
        el.classList.add("najiu-dog-track-current")
        dogNameEl.classList.add("najiu-dog-track-dog-name-current")
      } else {
        el.classList.add("najiu-dog-track")
      }
      dogNameEl.appendChild(dogName)
      el.appendChild(dogNameEl)
      //@ts-ignore
      myContainer.appendChild(el)
      myContainer.appendChild(dogNameEl)
      this.dogDiv.set(key, [el, dogNameEl])
    }
  }

  clearOldDogDiv() {
    for (const value of this.dogDiv.values()) {
      value[0].remove()
      value[1].remove()
    }
  }

  dispose() {
    this.arrayIndex = 0;
  }

}

videojs.registerComponent("DogTrack", DogTrack)