import videojs from 'video.js'

const Component = videojs.getComponent('Component');

class DogTrack extends Component {
  trackData = [] //传入初始数组
  dogDiv = new Map()
  processing = false//是否在处理中
  defaultWidth = 0
  defaultHeight = 0
  fullWidth = 0
  fullHeight = 0
  firstShowTrack = false
  isReplaceDisplayNone = false
  arrayIndex = 0
  preCurrentTime = 0

  constructor(player, options) {
    super(player, options);
    const this_ = this
    //player 默认宽高
    this.defaultWidth = player.el_.offsetWidth
    this.defaultHeight = player.el_.offsetHeight

    player.on("loadedmetadata", () => {
      console.log("视频时长单位秒", player.duration())
    })
    player.on("timeupdate", () => this.update())
    player.on("fullscreenchange", (e) => this.fullScreenChange.call(this_, e, player))
    player.on("ended", () => {
      this.arrayIndex = 0;
    })
  }

  fullScreenChange(e, player) {
    if (player.isFullscreen()) {
      this.fullWidth = e.currentTarget.offsetWidth
      this.fullHeight = e.currentTarget.offsetHeight
    }
  }

  update() {
    if (this.processing || this.trackData.length === 0) return
    const now = new Date().getTime()
    console.log("call", this.arrayIndex)
    this.processing = true
    const currentTime = this.player_.currentTime() * 1000
    //假如调整的播放时间则初始数组索引
    if (currentTime - this.preCurrentTime <= 0) {
      this.dispose()
    }
    //上次播放时间
    this.preCurrentTime = currentTime
    const firstFrameIndex = this.trackData[0][0] * 40
    //当前时间小于第一帧时间则直接跳过循环
    if (currentTime < firstFrameIndex) {
      this.processing = false
      return
    }
    for (let i = this.arrayIndex; i < this.trackData.length; i++) {
      const d = this.trackData[i]
      console.log(i, currentTime, d[0] * 40)
      if (firstFrameIndex <= currentTime && currentTime <= d[0] * 40) {
        this.arrayIndex = i
        this.trackDogs(d[1])
        break;
      }
    }
    this.processing = false
    console.log("currentTime 循环耗时", new Date().getTime() - now)
  }

  trackDogs(dogs) {
    if (!dogs) return
    for (const [key, value] of dogs.entries()) {
      const myel = this.dogDiv.get(key)
      if (!this.player_.isFullscreen()) {
        //跟踪框大小
        myel.style.width = `${(value.x2 - value.x1) * this.defaultWidth}px`
        myel.style.height = `${(value.y2 - value.y1) * (this.defaultHeight + 30)}px`
      } else {
        myel.style.width = `${(value.x2 - value.x1) * this.fullWidth}px`
        myel.style.height = `${(value.y2 - value.y1) * (this.fullHeight + 30)}px`
      }
      //跟踪框位置
      myel.style.top = `${value.y1 * 100}%`
      myel.style.left = `${value.x1 * 100}%`
      myel.className = myel.className.replace(/display-none/ig, "")
    }
    //清理掉当前frame没有的dog追踪
    for (const id of this.dogDiv.keys()) {
      if (!dogs.has(id)) {
        this.dogDiv.get(id).classList.add("display-none")
      }
    }
  }

  initData(dogIds: any, data: any, currentDogId: string) {
    if (!data || data.length === 0) return;
    //先清理之前狗跟踪的div
    this.clearOldDogDiv()
    this.dispose()
    //再清理数据
    this.dogDiv.clear()
    this.trackData.length = 0
    //创建狗的跟踪框
    this.createDogDiv(dogIds, currentDogId)
    //frame map 转数组
    this.trackData = Array.from(data);
    //播放时间跳转到第一帧时间
    setTimeout(() => {
      if (dogIds && dogIds.has(currentDogId)) {
        this.player_.currentTime((dogIds.get(currentDogId) * 40 - 30) / 1000)
      }
    }, 100);
  }

  createDogDiv(dogIds: any, currentDogId: string) {
    if (!dogIds || dogIds.size === 0) return;
    //@ts-ignore
    const myContainer = this.player_.getChild("MyContainer").el_;
    // console.log("key currentDogId", dogIds, currentDogId)
    for (const key of dogIds.keys()) {
      const el = document.createElement("div")
      el.id = `dog_${key}`
      el.classList.add("display-none")
      if (key === currentDogId) {
        el.classList.add("najiu-dog-track-current")
      } else {
        el.classList.add("najiu-dog-track")
      }
      //@ts-ignore
      myContainer.appendChild(el)
      this.dogDiv.set(key, el)
    }
  }

  clearOldDogDiv() {
    for (const value of this.dogDiv.values()) {
      value.remove()
    }
  }

  dispose() {
    this.arrayIndex = 0;
  }

}

videojs.registerComponent("DogTrack", DogTrack)