import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import "@/utils/rem";
import { Message, Table, TableColumn, Button } from 'element-ui';

Vue.config.productionTip = false;

Vue.use(Table)
Vue.use(TableColumn)
Vue.use(Button)
Vue.prototype.$message = Message;

router.beforeEach((to, from, next): void => {
  if (to.meta && to.meta.title) {
    document.title = to.meta.title
  } else {
    document.title = '天网犬只识别系统'
  }
  next()
})

new Vue({
  router,
  store,
  render: (h) => h(App),
}).$mount("#app");
