import videojs from 'video.js'

const Component = videojs.getComponent('Component');

//实现自己的容器
class MyContainer extends Component {
  constructor(player, options) {
    super(player, options)
  }

  createEl() {
    const container = document.createElement("div")
    container.classList.add("my-container")
    container.onclick = () => {
      //播放状态
      if (this.player_.paused()) {
        this.player_.play()
      } else {
        this.player_.pause()
      }
    }
    container.oncontextmenu = function () {
      console.log("鼠标右键")
      return false
    }

    return container
  }

  handleClick(event) {
    console.log("container", event)
  }
}

videojs.registerComponent("MyContainer", MyContainer)