import videojs from 'video.js'

const Component = videojs.getComponent('Component');

class DogTrack extends Component {
  trackData = [] //传入初始数组
  dogDiv = new Map()
  processing = false//是否在处理中
  firstShowTrack = false
  isReplaceDisplayNone = false
  arrayIndex = 0
  preCurrentTime = 0

  constructor(player, options) {
    super(player, options);

    player.on("loadedmetadata", () => {
      console.log("视频时长单位秒", player.duration())
    })
    player.on("timeupdate", () => this.update())
    // player.on("fullscreenchange", (e) => this.fullScreenChange.call(this_, e, player))
    player.on("ended", () => {
      this.arrayIndex = 0;
    })
  }

  // fullScreenChange(e, player) {
  //   if (player.isFullscreen()) {
  //     console.log("full", e.currentTarget.offsetWidth, e.currentTarget.offsetHeight)
  //   }
  // }

  update() {
    if (this.processing || this.trackData.length === 0) return
    // const now = new Date().getTime()
    // console.log("call", this.arrayIndex)
    this.processing = true
    const currentTime = this.player_.currentTime() * 1000
    //假如调整的播放时间则初始数组索引
    if (currentTime - this.preCurrentTime <= 0) {
      this.dispose()
    }
    //上次播放时间
    this.preCurrentTime = currentTime
    const firstFrameIndex = this.trackData[0][0] * 40
    //当前时间小于第一帧时间则直接跳过循环
    if (currentTime < firstFrameIndex) {
      this.processing = false
      return
    }
    for (let i = this.arrayIndex; i < this.trackData.length; i++) {
      const d = this.trackData[i]
      // console.log(i, currentTime, d[0] * 40)
      if (firstFrameIndex <= currentTime && currentTime <= d[0] * 40) {
        this.arrayIndex = i
        this.trackDogs(d[1])
        break;
      }
    }
    this.processing = false
    // console.log("currentTime 循环耗时", new Date().getTime() - now)
  }

  trackDogs(dogs) {
    if (!dogs) return
    for (const [key, value] of dogs.entries()) {
      const myel = this.dogDiv.get(key)
      //跟踪框大小
      myel[0].style.width = `${(value.x2 - value.x1) * this.player_.currentWidth()}px`
      myel[0].style.height = `${(value.y2 - value.y1) * (this.player_.currentHeight() + 30)}px`
      //跟踪框位置
      const t = value.y1 * this.player_.currentHeight()
      const l = value.x1 * this.player_.currentWidth()
      myel[0].style.top = `${t}px`
      myel[0].style.left = `${l}px`
      myel[1].style.top = `${t - 21}px`
      myel[1].style.left = `${l - 5}px`

      myel[0].className = myel[0].className.replace(/display-none/ig, "")
      myel[1].className = myel[1].className.replace(/display-none/ig, "")
    }
    //清理掉当前frame没有的dog追踪
    for (const id of this.dogDiv.keys()) {
      if (!dogs.has(id)) {
        const arrEl = this.dogDiv.get(id)
        arrEl[0].classList.add("display-none")
        arrEl[1].classList.add("display-none")
      }
    }
  }

  initData(dogIds: any, data: any, currentDogId: string) {
    if (!data || data.length === 0) return;
    //先清理之前狗跟踪的div
    this.clearOldDogDiv()
    this.dispose()
    //再清理数据
    this.dogDiv.clear()
    this.trackData.length = 0
    //创建狗的跟踪框
    this.createDogDiv(dogIds, currentDogId)
    //frame map 转数组
    this.trackData = Array.from(data);
    //播放时间跳转到第一帧时间
    setTimeout(() => {
      const numberDogId = Number(currentDogId)
      if (dogIds && dogIds.has(numberDogId)) {
        this.player_.currentTime((dogIds.get(numberDogId).FrameIndex * 40 - 30) / 1000)
      }
    }, 100);
  }

  createDogDiv(dogIds: any, currentDogId: string) {
    if (!dogIds || dogIds.size === 0) return;
    //@ts-ignore
    const myContainer = this.player_.el_;
    // console.log("key currentDogId", dogIds, currentDogId, myContainer)
    for (const [key, value] of dogIds) {
      //定位框元素
      const el = document.createElement("div")
      el.id = `dog_${key}`
      el.classList.add("display-none")
      //dog name
      const dogNameEl = document.createElement("div")
      dogNameEl.classList.add("najiu-dog-track-dog-name")
      dogNameEl.id = `dog_name_${key}`
      //@ts-ignore
      const dogName = document.createTextNode(`狗${value.obj_id}`)
      if (key == currentDogId) {
        el.classList.add("najiu-dog-track-current")
        dogNameEl.classList.add("najiu-dog-track-dog-name-current")
      } else {
        el.classList.add("najiu-dog-track")
      }
      dogNameEl.appendChild(dogName)
      el.appendChild(dogNameEl)
      //@ts-ignore
      myContainer.appendChild(el)
      myContainer.appendChild(dogNameEl)
      this.dogDiv.set(key, [el, dogNameEl])
    }
  }

  clearOldDogDiv() {
    for (const value of this.dogDiv.values()) {
      value[0].remove()
      value[1].remove()
    }
  }

  dispose() {
    this.arrayIndex = 0;
  }

}

videojs.registerComponent("DogTrack", DogTrack)