// 引入等比适配插件
const px2rem = require("postcss-px2rem");
// 配置基本大小
const postcss = px2rem({
  // 基准大小 baseSize，需要和rem.js中相同
  remUnit: 16,
});

module.exports = {
  chainWebpack: (config) => {
    config.devtool(
      process.env.NODE_ENV === "production" ? "none" : "inline-source-map"
    );
    config.plugin("html").tap((args) => {
      args[0].title = "天网犬只识别系统";
      return args;
    });
  },
  css: {
    loaderOptions: {
      postcss: {
        plugins: [postcss],
      },
      sass: {
        prependData: `@import
        "@/assets/scss/variable.scss";`,
      },
    },
  },
};
