import { responseData } from '@/types/response'
import { Message } from 'element-ui'
import api from '@/configs/apiConfig'

/**
 * 使用Promise封装Fetch，具有网络超时、请求终止的功能
 */
class NetUtil {

    static token = '';

    /**
     * post请求
     * url : 请求地址
     * data : 参数(Json对象)
     * callback : 回调函数
     * */
    static fetch_request(url: string, method: 'POST' | 'GET', params = ''): Promise<responseData> {
        const header = {
            'Accept': 'application/json',
            'Content-Type': 'application/json;charset=UTF-8',
            'accesstoken': NetUtil.token,
        }

        let promise = null;
        if (params == '') {
            promise = new Promise((resolve, reject) => {
                fetch(api.skyNet + url, { method: method, headers: header })
                    .then(response => response.json())
                    .then(responseData => resolve(responseData))
                    .then(err => reject(err))
            })
        } else {
            promise = new Promise((resolve, reject) => {
                fetch(api.skyNet + url, { method: method, headers: header, body: JSON.stringify(params) })
                    .then(response => {
                        if (response.status === 404) {
                            throw Error("网络404错误!")
                        }
                        return response.json()
                    })
                    .then(responseData => resolve(responseData))
                    .then(err => reject(err))
                    .catch(err => {
                        reject(err)
                    })
            })
        }

        return NetUtil.warp_fetch(promise).catch(err => {
            Message.error(err)
            throw err
        });
    }


    /**
     * 创建两个promise对象，一个负责网络请求，另一个负责计时，如果超过指定时间，就会先回调计时的promise，代表网络超时。
     * @param {Promise} fetch_promise    fetch请求返回的Promise
     * @param {number} [timeout=10000]   单位：毫秒，这里设置默认超时时间为10秒
     * @return 返回Promise
     */
    static warp_fetch(fetch_promise: Promise<responseData>, timeout = 5000): Promise<responseData> {
        let timeout_fn = null;
        let abort = null;
        //创建一个超时promise
        const timeout_promise: Promise<responseData> = new Promise(function (resolve, reject) {
            timeout_fn = function () {
                reject('网络请求超时');
            };
        });
        //创建一个终止promise
        const abort_promise: Promise<responseData> = new Promise(function (resolve, reject) {
            abort = function () {
                reject('请求终止');
            };
        });
        //竞赛
        const abortable_promise = Promise.race([
            fetch_promise,
            timeout_promise,
            abort_promise,
        ]);
        //计时
        setTimeout(timeout_fn, timeout);
        //终止
        //@ts-ignore
        abortable_promise.abort = abort;
        return abortable_promise;
    }
}

export default NetUtil;