import videojs from 'video.js'
import { TrackData } from "../data"

const Component = videojs.getComponent('Component');

class DogTrack extends Component {
  trackData = [] //传入初始数组
  processing = false//是否在处理中
  myel = undefined
  defaultWidth = 0
  defaultHeight = 0
  defaultElWidth = ""
  defaultElHeight = ""

  constructor(player, options) {
    super(player, options);
    const this_ = this
    //player 默认宽高
    this.defaultWidth = player.el_.offsetWidth
    this.defaultHeight = player.el_.offsetHeight

    player.on("timeupdate", (e) => this.update(e))
    player.on("fullscreenchange", (e) => this.fullScreenChange.call(this_, e, player))
  }



  createEl(): HTMLDivElement {
    const el = document.createElement("div")
    el.id = "trackDiv"
    el.classList.add("najiu-dog-track")
    return el;
  }

  fullScreenChange(e, player) {
    if (player.isFullscreen()) {
      this.myel.style.width = `${this.myel.offsetWidth * (e.currentTarget.offsetWidth / this.defaultWidth)}px`
      this.myel.style.height = `${this.myel.offsetHeight * (e.currentTarget.offsetHeight / this.defaultHeight)}px`
    } else {
      this.myel.style.width = this.defaultElWidth
      this.myel.style.height = this.defaultElHeight
    }
  }

  update(e) {
    if (this.processing || this.trackData.length === 0 || !this.myel) return
    this.processing = true
    const currentTime = this.player_.currentTime() * 1000
    for (let i = 0; i < this.trackData.length; i++) {
      const d = this.trackData[i]
      if (currentTime > d.beginTime && currentTime < d.endTime) {
        this.myel.style.top = `${d.position.top}%`
        this.myel.style.left = `${d.position.left}%`
        break;
      }
    }
    this.processing = false
  }

  initData(data: TrackData[]) {
    this.trackData.length = 0
    if (!data || data.length === 0) return;
    this.myel = document.getElementById("trackDiv")
    this.myel.style.width = `${data[0].shape.width}px`
    this.myel.style.height = `${data[0].shape.height}px`
    this.defaultElHeight = this.myel.style.height
    this.defaultElWidth = this.myel.style.width

    for (let i = 0; i < data.length; i++) {
      const d = data[i]
      if (i === data.length - 1) {
        this.trackData.push({ ...d, beginTime: d.time, endTime: Number.MAX_SAFE_INTEGER })
      } else {
        this.trackData.push({ ...d, beginTime: d.time, endTime: data[i + 1].time })
      }
    }
    console.log("data", this.trackData)
  }




}

videojs.registerComponent("DogTrack", DogTrack)