import localforage from 'localforage'

export const setItem = (key: string, data: any) => {
  try {
    localforage.setItem(key, data)
  } catch (e) {
    console.log('indexDb save error', e)
  }
}

export const getItem = async (key: string) => {
  try {
    return await localforage.getItem(key)
  } catch (e) {
    console.log('indexDb get error', e)
    return undefined
  }
}

export const clear = (key = '') => {
  try {
    if (!key) {
      localforage.clear()
      return
    }
    localforage.removeItem(key)
  } catch (e) {
    console.log('indexDb clear error', e)
  }
}