import Vue from "vue";
import VueRouter from "vue-router";
import Dashboard from "@/views/dashboard/index.vue";
import { MyRouteConfig } from "./myRouteConfig";

Vue.use(VueRouter);

const routes: Array<MyRouteConfig> = [
  {
    path: "/",
    name: "Dashboard",
    component: Dashboard,
    meta: {
      title: "视频识别",
      icon: "shexiangtou",
    },
    show: true,
  },
  {
    path: "/aiSearch",
    name: "AiSearch",
    component: () => import("@/views/aiSearch/index.vue"),
    meta: {
      title: "智能检索",
      icon: "filesearch",
    },
    show: true,
  },
  {
    path: "/dogHot",
    name: "DogHot",
    show: true,
    meta: {
      title: "犬只热力",
      icon: "diannaoliushui",
    },
    component: () => import("../views/dogHot/index.vue"),
  },
  {
    path: "/sysSetting",
    name: "SysSetting",
    show: true,
    meta: {
      title: "系统设置",
      icon: "xitongshezhi",
    },
    component: () => import("../views/sysSetting/index.vue"),
  }
];

const router = new VueRouter({
  routes,
});

export default router;
