import videojs from 'video.js'
import { TrackData } from "../data"

const Component = videojs.getComponent('Component');

class DogTrack extends Component {
  trackData = [] //传入初始数组
  processing = false//是否在处理中
  myel = undefined
  defaultWidth = 0
  defaultHeight = 0
  fullWidth = 0
  fullHeight = 0
  firstShowTrack = false
  isReplaceDisplayNone = false
  arrayIndex = 0
  preCurrentTime = 0

  constructor(player, options) {
    super(player, options);
    const this_ = this
    //player 默认宽高
    this.defaultWidth = player.el_.offsetWidth
    this.defaultHeight = player.el_.offsetHeight

    player.on("timeupdate", (e) => this.update(e))
    player.on("fullscreenchange", (e) => this.fullScreenChange.call(this_, e, player))
    player.on("ended", () => {
      this.arrayIndex = 0;
    })
  }

  createEl(): HTMLDivElement {
    const el = document.createElement("div")
    el.id = "trackDiv"
    el.classList.add("display-none")
    el.classList.add("najiu-dog-track")
    return el;
  }

  fullScreenChange(e, player) {
    if (player.isFullscreen()) {
      this.fullWidth = e.currentTarget.offsetWidth
      this.fullHeight = e.currentTarget.offsetHeight
    }
  }

  update(e) {
    if (this.processing || this.trackData.length === 0 || !this.myel) return
    this.processing = true
    const currentTime = this.player_.currentTime() * 1000
    //假如调整的播放时间则初始数组索引
    if (currentTime - this.preCurrentTime <= 0) {
      this.dispose()
    }
    //上次播放时间
    this.preCurrentTime = currentTime
    const firstFrameIndex = this.trackData[0].FrameIndex * 40
    for (let i = this.arrayIndex; i < this.trackData.length; i++) {
      const d = this.trackData[i]
      if (firstFrameIndex <= currentTime && currentTime <= d.FrameIndex * 40) {
        //
        this.arrayIndex = i
        console.log("arrayIndex", this.arrayIndex, d.FrameIndex)
        if (!this.player_.isFullscreen()) {
          //跟踪框大小
          this.myel.style.width = `${(d.x2 - d.x1) * this.defaultWidth}px`
          this.myel.style.height = `${(d.y2 - d.y1) * this.defaultHeight}px`
        } else {
          this.myel.style.width = `${(d.x2 - d.x1) * this.fullWidth}px`
          this.myel.style.height = `${(d.y2 - d.y1) * this.fullHeight}px`
        }
        //跟踪框位置
        this.myel.style.top = `${d.y1 * 100}%`
        this.myel.style.left = `${d.x1 * 100}%`
        if (!this.isReplaceDisplayNone) {
          this.isReplaceDisplayNone = true
          this.myel.className = this.myel.className.replace(/display-none/ig, "")
        }
        break;
      }
    }
    this.processing = false
  }

  initData(data: TrackData[]) {
    this.trackData.length = 0
    if (!data || data.length === 0) return;
    this.trackData = data;
    this.myel = document.getElementById("trackDiv")
    this.dispose()
    const this_ = this
    setTimeout(() => {
      this.player_.currentTime((this_.trackData[0].FrameIndex * 40 - 30) / 1000)
    }, 100);
  }

  dispose() {
    this.arrayIndex = 0
    this.myel.classList.add("display-none")
    this.isReplaceDisplayNone = false
  }

  hideTrackDiv() {
    if (this.myel) {
      this.myel.classList.add("display-none")
    }
  }


}

videojs.registerComponent("DogTrack", DogTrack)