import { responseData } from "@/types/response"
import NetUtil from '@/utils/http'
import api from '@/configs/apiConfig'

export function getCamera(pageData: any): Promise<responseData> {
  return NetUtil.fetch_request('camera/paging', 'POST', pageData)
}

export function updCamera(data: any) {
  return NetUtil.fetch_request('camera/updCamera', 'POST', data)
}

export function addCamera(data: any) {
  return NetUtil.fetch_request('camera/addCamera', 'POST', data)
}

export function delCamera(id: string) {
  return NetUtil.fetch_request('camera/delCamera/' + id, 'POST')
}

export async function getCameraDogFormate(data: any) {
  const rp = await getCameraDog(data)
  if (rp.code !== 0) return {}
  if (!rp.data || rp.data.length === 0) return undefined
  //组装数据结构
  const ar = {}
  rp.data.forEach(d => {
    if (!ar[d.groupName]) {
      ar[d.groupName] = [d]
    } else {
      ar[d.groupName].push(d)
    }
  })
  return ar
}

export async function getCameraDog(data: any) {
  const rp = await NetUtil.fetch_request('video/cameraDog', 'POST', data)
  return rp
}

export function pageDogInfo(data: any) {
  return NetUtil.fetch_request('video/pageDogInfo/', 'POST', data)
}

export function getLabelInfo(fileName: string) {
  return fetch(
    `${api.skyNet}video/getLabelInfo?path=${fileName}`,
    { headers: { "Accept-Encoding": "gzip" } }
  )
    .then((response) => {
      return response.json();
    })
    .then((data) => {
      return data
    });
}