import type { Plugin } from 'vite';

import PurgeIcons from 'vite-plugin-purge-icons';

import visualizer from 'rollup-plugin-visualizer';

// @ts-ignore
import pkg from '../../../package.json';
import { ViteEnv, isReportMode } from '../../utils';
import { configHtmlPlugin } from './html';
import { configPwaConfig } from './pwa';
import { configMockPlugin } from './mock';
import { configDynamicImport } from './importContext';
import { configGzipPlugin } from './gzip';

// gen vite plugins
export function createVitePlugins(viteEnv: ViteEnv, isBuild: boolean, mode: string) {
  const vitePlugins: (Plugin | Plugin[])[] = [];

  // vite-plugin-html
  vitePlugins.push(configHtmlPlugin(viteEnv, isBuild));

  // vite-plugin-pwa
  vitePlugins.push(configPwaConfig(viteEnv, isBuild));

  // vite-plugin-mock
  vitePlugins.push(configMockPlugin(viteEnv, isBuild));

  // vite-plugin-import-context
  vitePlugins.push(configDynamicImport(viteEnv));

  // vite-plugin-purge-icons
  vitePlugins.push(PurgeIcons());

  // rollup-plugin-gzip
  vitePlugins.push(configGzipPlugin(isBuild));

  // rollup-plugin-visualizer
  if (isReportMode()) {
    vitePlugins.push(visualizer({ filename: './build/.cache/stats.html', open: true }) as Plugin);
  }

  return vitePlugins;
}
